/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.BaseService;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.core.Sink;
import jade.core.SliceProxy;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;
import java.util.Vector;

public class ServiceManagerImpl
implements ServiceManager,
ServiceFinder {
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor;
    private PlatformManager myPlatformManager;
    private boolean invalidPlatformManager;
    private String platformName;
    private Node localNode;
    private NodeDescriptor localNodeDescriptor;
    private Map localServices;
    private Map backupManagers;
    private Logger myLogger;

    ServiceManagerImpl(Profile p, PlatformManager pm) throws ProfileException {
        this.myCommandProcessor = p.getCommandProcessor();
        this.myIMTPManager = p.getIMTPManager();
        this.myPlatformManager = pm;
        this.invalidPlatformManager = false;
        this.localServices = new HashMap(5);
        this.backupManagers = new HashMap(1);
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    public String getPlatformName() throws IMTPException {
        if (this.platformName == null) {
            try {
                this.platformName = this.myPlatformManager.getPlatformName();
            }
            catch (IMTPException imtpe) {
                if (this.reconnect()) {
                    this.platformName = this.myPlatformManager.getPlatformName();
                }
                throw imtpe;
            }
        }
        return this.platformName;
    }

    public synchronized void addAddress(String addr) throws IMTPException {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Adding PlatformManager address " + addr);
        }
        if (this.invalidPlatformManager || !addr.equals(this.myPlatformManager.getLocalAddress())) {
            this.backupManagers.put(addr, this.myIMTPManager.getPlatformManagerProxy(addr));
            if (this.invalidPlatformManager) {
                this.reconnect();
            }
        }
    }

    public synchronized void removeAddress(String addr) throws IMTPException {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Removing PlatformManager address " + addr);
        }
        this.backupManagers.remove(addr);
        if (addr.equals(this.myPlatformManager.getLocalAddress())) {
            this.reconnect();
        }
    }

    public String getLocalAddress() throws IMTPException {
        return this.myPlatformManager.getLocalAddress();
    }

    public void addNode(NodeDescriptor desc, ServiceDescriptor[] services) throws IMTPException, ServiceException, JADESecurityException {
        this.localNodeDescriptor = desc;
        this.localNode = desc.getNode();
        try {
            Vector<ServiceDescriptor> ss = new Vector<ServiceDescriptor>(services != null ? services.length : 0);
            if (services != null) {
                int i = 0;
                while (i < services.length) {
                    try {
                        this.installServiceLocally(services[i]);
                        ss.addElement(services[i]);
                    }
                    catch (Exception e) {
                        if (services[i].isMandatory()) {
                            throw e;
                        }
                        this.myLogger.log(Logger.WARNING, "Exception installing service " + services[i].getService() + ". " + e);
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            String name = null;
            try {
                name = this.myPlatformManager.addNode(desc, ss, false);
            }
            catch (IMTPException imtpe) {
                if (this.reconnect()) {
                    name = this.myPlatformManager.addNode(desc, ss, false);
                }
                throw imtpe;
            }
            this.adjustName(name);
        }
        catch (IMTPException imtpe2) {
            throw imtpe2;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (JADESecurityException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ServiceException("Unexpected error activating node", t);
        }
    }

    public void removeNode(NodeDescriptor desc) throws IMTPException, ServiceException {
        Object[] names = this.localServices.keySet().toArray();
        int i = 0;
        while (i < names.length) {
            try {
                String svcName = (String)names[i];
                this.uninstallServiceLocally(svcName);
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
            ++i;
        }
        if (desc.getNode().hasPlatformManager()) {
            this.myIMTPManager.unexportPlatformManager(this.myPlatformManager);
        }
    }

    public void activateService(ServiceDescriptor desc) throws IMTPException, ServiceException {
        block5: {
            try {
                this.installServiceLocally(desc);
                try {
                    this.myPlatformManager.addSlice(desc, this.localNodeDescriptor, false);
                }
                catch (IMTPException imtpe) {
                    if (this.reconnect()) {
                        this.myPlatformManager.addSlice(desc, this.localNodeDescriptor, false);
                        break block5;
                    }
                    throw imtpe;
                }
            }
            catch (IMTPException imtpe2) {
                this.uninstallServiceLocally(desc.getName());
                throw imtpe2;
            }
        }
    }

    public void deactivateService(String name) throws IMTPException, ServiceException {
        ServiceDescriptor desc = (ServiceDescriptor)this.localServices.get(name);
        if (desc != null) {
            try {
                this.myPlatformManager.removeSlice(name, this.localNode.getName(), false);
            }
            catch (IMTPException imtpe) {
                if (this.reconnect()) {
                    this.myPlatformManager.removeSlice(name, this.localNode.getName(), false);
                }
                throw imtpe;
            }
            this.uninstallServiceLocally(name);
        }
    }

    public Service findService(String key) throws IMTPException, ServiceException {
        Service svc = null;
        ServiceDescriptor svcDsc = (ServiceDescriptor)this.localServices.get(key);
        if (svcDsc != null) {
            svc = svcDsc.getService();
        }
        return svc;
    }

    public Service.Slice findSlice(String serviceKey, String sliceKey) throws IMTPException, ServiceException {
        Service.Slice slice = null;
        try {
            slice = this.myPlatformManager.findSlice(serviceKey, sliceKey);
        }
        catch (IMTPException imtpe) {
            if (this.reconnect()) {
                slice = this.myPlatformManager.findSlice(serviceKey, sliceKey);
            }
            throw imtpe;
        }
        return this.checkLocal(slice);
    }

    public Service.Slice[] findAllSlices(String serviceKey) throws IMTPException, ServiceException {
        Vector v = null;
        try {
            v = this.myPlatformManager.findAllSlices(serviceKey);
        }
        catch (IMTPException imtpe) {
            if (this.reconnect()) {
                v = this.myPlatformManager.findAllSlices(serviceKey);
            }
            throw imtpe;
        }
        if (v == null) {
            return null;
        }
        Service.Slice[] ss = new Service.Slice[v.size()];
        int i = 0;
        while (i < ss.length) {
            ss[i] = this.checkLocal((Service.Slice)v.elementAt(i));
            ++i;
        }
        return ss;
    }

    private void installServiceLocally(ServiceDescriptor svcDsc) throws IMTPException, ServiceException {
        Service.Slice localSlice;
        Sink sTgt;
        Sink sSrc;
        Filter fIn;
        Service svc = svcDsc.getService();
        Filter fOut = svc.getCommandFilter(true);
        if (fOut != null) {
            fOut.setServiceName(svc.getName());
            this.myCommandProcessor.addFilter(fOut, true);
        }
        if ((fIn = svc.getCommandFilter(false)) != null) {
            if (fIn == fOut) {
                this.myCommandProcessor.removeFilter(fOut, true);
                throw new ServiceException("The same filter object cannot be used as both incoming and outgoing filter.");
            }
            fIn.setServiceName(svc.getName());
            this.myCommandProcessor.addFilter(fIn, false);
        }
        if ((sSrc = svc.getCommandSink(false)) != null) {
            this.myCommandProcessor.registerSink(sSrc, false, svc.getName());
        }
        if ((sTgt = svc.getCommandSink(true)) != null) {
            this.myCommandProcessor.registerSink(sTgt, true, svc.getName());
        }
        if ((localSlice = svc.getLocalSlice()) != null) {
            this.localNode.exportSlice(svc.getName(), localSlice);
        }
        this.localServices.put(svc.getName(), svcDsc);
        if (svc instanceof BaseService) {
            BaseService bs = (BaseService)svc;
            bs.setCommandProcessor(this.myCommandProcessor);
        }
    }

    private void uninstallServiceLocally(String name) throws IMTPException, ServiceException {
        ServiceDescriptor svcDsc = (ServiceDescriptor)this.localServices.get(name);
        if (svcDsc != null) {
            Sink sTgt;
            Sink sSrc;
            Filter fIn;
            Service svc = svcDsc.getService();
            svc.shutdown();
            Filter fOut = svc.getCommandFilter(true);
            if (fOut != null) {
                this.myCommandProcessor.removeFilter(fOut, true);
            }
            if ((fIn = svc.getCommandFilter(false)) != null) {
                this.myCommandProcessor.removeFilter(fIn, false);
            }
            if ((sSrc = svc.getCommandSink(false)) != null) {
                this.myCommandProcessor.deregisterSink(false, svc.getName());
            }
            if ((sTgt = svc.getCommandSink(true)) != null) {
                this.myCommandProcessor.deregisterSink(true, svc.getName());
            }
        }
        this.localNode.unexportSlice(name);
        this.localServices.remove(name);
    }

    synchronized void reattach(String pmAddr) {
        block4: {
            if (!this.invalidPlatformManager && !pmAddr.equals(this.myPlatformManager.getLocalAddress())) break block4;
            this.invalidatePlatformManager();
            try {
                this.myPlatformManager = this.myIMTPManager.getPlatformManagerProxy(pmAddr);
                String name = this.myPlatformManager.addNode(this.localNodeDescriptor, this.getLocalServices(), false);
                if (!name.equals(this.localNodeDescriptor.getName())) {
                    this.myLogger.log(Logger.WARNING, "Container name changed re-attaching to PlatformManager: new name = " + name);
                }
                this.adjustName(name);
                this.handlePMRefreshed(pmAddr);
                System.out.println("Issuing REATTACHED Incoming command");
                GenericCommand gCmd = new GenericCommand("Reattached", null, null);
                Object result = this.myCommandProcessor.processIncoming(gCmd);
                if (result instanceof Throwable) {
                    this.myLogger.log(Logger.SEVERE, "Unexpected error processing REATTACHED command.");
                    ((Throwable)result).printStackTrace();
                }
                this.myLogger.log(Logger.INFO, "Re-attached to PlatformManager at " + pmAddr);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.SEVERE, "Cannot re-attach to PlatformManager at " + pmAddr + ". " + e);
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean reconnect() {
        try {
            this.myPlatformManager.ping();
            return true;
        }
        catch (IMTPException imtpe) {
            this.invalidatePlatformManager();
            it = this.backupManagers.keySet().iterator();
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            addr = (String)it.next();
            try {
                this.myPlatformManager = (PlatformManager)this.backupManagers.get(addr);
                this.myLogger.log(Logger.INFO, "Reconnecting to PlatformManager at address " + this.myPlatformManager.getLocalAddress());
                this.myPlatformManager.adopt(this.localNode, null);
                this.handlePMRefreshed(addr);
                this.myLogger.log(Logger.INFO, "Reconnection OK");
                return true;
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Reconnection failed");
            }
            continue;
        }
lbl19:
        // 1 sources

        return false;
    }

    private void invalidatePlatformManager() {
        if (!this.invalidPlatformManager) {
            this.invalidPlatformManager = true;
            GenericCommand gCmd = new GenericCommand("Dead-Platform-Manager", null, null);
            gCmd.addParam(this.myPlatformManager.getLocalAddress());
            Object result = this.myCommandProcessor.processIncoming(gCmd);
            if (result instanceof Throwable) {
                this.myLogger.log(Logger.WARNING, "Unexpected error processing DEAD_PLATFORM_MANAGER command.");
                ((Throwable)result).printStackTrace();
            }
        }
    }

    private void handlePMRefreshed(String pmAddr) {
        Object[] services = this.localServices.values().toArray();
        int i = 0;
        while (i < services.length) {
            ServiceDescriptor svcDsc = (ServiceDescriptor)services[i];
            Service svc = svcDsc.getService();
            if (svc instanceof BaseService) {
                ((BaseService)svc).clearCachedSlice("$$$Main-Slice$$$");
            }
            ++i;
        }
        this.myIMTPManager.reconnected(this.myPlatformManager);
        this.backupManagers.remove(pmAddr);
        this.invalidPlatformManager = false;
    }

    private Vector getLocalServices() {
        Object[] services = this.localServices.values().toArray();
        Vector<Object> ss = new Vector<Object>(services.length);
        int i = 0;
        while (i < services.length) {
            ss.addElement(services[i]);
            ++i;
        }
        return ss;
    }

    private void adjustName(String name) {
        this.localNodeDescriptor.setName(name);
        this.localNode.setName(name);
        ContainerID cid = this.localNodeDescriptor.getContainer();
        if (cid != null) {
            cid.setName(name);
        }
    }

    private Service.Slice checkLocal(Service.Slice slice) throws ServiceException {
        Node n;
        if (slice != null && (n = slice.getNode()).getName().equals(this.localNode.getName()) && !n.equals(this.localNode)) {
            ((SliceProxy)slice).setNode(this.localNode);
        }
        return slice;
    }
}

